/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class BiomeDictionary {
    private static final boolean DEBUG = false;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ResourceKey<Biome>, BiomeInfo> biomeInfoMap = new HashMap<ResourceKey<Biome>, BiomeInfo>();

    public static void init() {
    }

    public static void addTypes(ResourceKey<Biome> biome, Type ... types) {
        Collection<Type> supertypes = BiomeDictionary.listSupertypes(types);
        Collections.addAll(supertypes, types);
        for (Type type : supertypes) {
            type.biomes.add(biome);
        }
        BiomeInfo biomeInfo = BiomeDictionary.getBiomeInfo(biome);
        Collections.addAll(biomeInfo.types, types);
        biomeInfo.types.addAll(supertypes);
    }

    @Nonnull
    public static Set<ResourceKey<Biome>> getBiomes(Type type) {
        return type.biomesUn;
    }

    @Nonnull
    public static Set<Type> getTypes(ResourceKey<Biome> biome) {
        return BiomeDictionary.getBiomeInfo(biome).typesUn;
    }

    public static boolean areSimilar(ResourceKey<Biome> biomeA, ResourceKey<Biome> biomeB) {
        Set<Type> typesA = BiomeDictionary.getTypes(biomeA);
        Set<Type> typesB = BiomeDictionary.getTypes(biomeB);
        return typesA.stream().anyMatch(typesB::contains);
    }

    public static boolean hasType(ResourceKey<Biome> biome, Type type) {
        return BiomeDictionary.getTypes(biome).contains(type);
    }

    public static boolean hasAnyType(ResourceKey<Biome> biome) {
        return !BiomeDictionary.getBiomeInfo(biome).types.isEmpty();
    }

    private static BiomeInfo getBiomeInfo(ResourceKey<Biome> biome) {
        return biomeInfoMap.computeIfAbsent(biome, k -> new BiomeInfo());
    }

    private static Collection<Type> listSupertypes(Type ... types) {
        HashSet<Type> supertypes = new HashSet<Type>();
        ArrayDeque<Type> next = new ArrayDeque<Type>();
        Collections.addAll(next, types);
        while (!next.isEmpty()) {
            Type type = (Type)next.remove();
            for (Type sType : Type.byName.values()) {
                if (!sType.subTypes.contains(type) || !supertypes.add(sType)) continue;
                next.add(sType);
            }
        }
        return supertypes;
    }

    private static void registerVanillaBiomes() {
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48174_, Type.OCEAN, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48202_, Type.PLAINS, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48203_, Type.HOT, Type.DRY, Type.SANDY, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_186765_, Type.HILLS, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48205_, Type.FOREST, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48206_, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48207_, Type.WET, Type.SWAMP, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48208_, Type.RIVER, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48209_, Type.HOT, Type.DRY, Type.NETHER);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48210_, Type.COLD, Type.DRY, Type.END);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48211_, Type.COLD, Type.OCEAN, Type.SNOWY, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48212_, Type.COLD, Type.RIVER, Type.SNOWY, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_186761_, Type.COLD, Type.SNOWY, Type.WASTELAND, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48215_, Type.MUSHROOM, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48217_, Type.BEACH, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48222_, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_186769_, Type.HOT, Type.WET, Type.JUNGLE, Type.FOREST, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48225_, Type.OCEAN, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_186760_, Type.BEACH, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48148_, Type.COLD, Type.BEACH, Type.SNOWY, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48149_, Type.FOREST, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48151_, Type.SPOOKY, Type.DENSE, Type.FOREST, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48152_, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_186763_, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_186767_, Type.HILLS, Type.FOREST, Type.SPARSE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48157_, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48158_, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE, Type.RARE, Type.OVERWORLD, Type.SLOPE, Type.PLATEAU);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48159_, Type.MESA, Type.SANDY, Type.DRY, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_186753_, Type.MESA, Type.SANDY, Type.DRY, Type.SPARSE, Type.OVERWORLD, Type.SLOPE, Type.PLATEAU);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_186754_, Type.PLAINS, Type.PLATEAU, Type.SLOPE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_186755_, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.SLOPE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_186756_, Type.COLD, Type.SPARSE, Type.SNOWY, Type.SLOPE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_186758_, Type.COLD, Type.SPARSE, Type.SNOWY, Type.PEAK, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_186757_, Type.COLD, Type.SPARSE, Type.SNOWY, Type.PEAK, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_186759_, Type.HOT, Type.PEAK, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48162_, Type.END);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48163_, Type.END);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48164_, Type.END);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48165_, Type.END);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48166_, Type.OCEAN, Type.HOT, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48167_, Type.OCEAN, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48168_, Type.OCEAN, Type.COLD, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48170_, Type.OCEAN, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48171_, Type.OCEAN, Type.COLD, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48172_, Type.OCEAN, Type.COLD, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48173_, Type.VOID);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48176_, Type.PLAINS, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_186766_, Type.HILLS, Type.SPARSE, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48179_, Type.FOREST, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48182_, Type.COLD, Type.SNOWY, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_186762_, Type.FOREST, Type.DENSE, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_186764_, Type.DENSE, Type.FOREST, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_186768_, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.HILLS, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48194_, Type.MESA, Type.HOT, Type.DRY, Type.SPARSE, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48197_, Type.HOT, Type.WET, Type.RARE, Type.JUNGLE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_151785_, Type.UNDERGROUND, Type.LUSH, Type.WET, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_151784_, Type.UNDERGROUND, Type.SPARSE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48199_, Type.HOT, Type.DRY, Type.NETHER);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48200_, Type.HOT, Type.DRY, Type.NETHER, Type.FOREST);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48201_, Type.HOT, Type.DRY, Type.NETHER, Type.FOREST);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48175_, Type.HOT, Type.DRY, Type.NETHER);
    }

    private static /* synthetic */ ResourceKey lambda$registerVanillaBiomes$4(Biome b) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)b.getRegistryName());
    }

    private static /* synthetic */ void lambda$registerVanillaBiomes$3(StringBuilder buf, Type type) {
        buf.append("    ").append(type.name).append(": ").append(type.biomes.stream().map(ResourceKey::m_135782_).sorted((a, b) -> a.compareNamespaced(b)).map(Object::toString).collect(Collectors.joining(", "))).append('\n');
    }

    private static /* synthetic */ int lambda$registerVanillaBiomes$1(Type l, Type r) {
        return l.getName().compareTo(r.getName());
    }

    static {
        BiomeDictionary.registerVanillaBiomes();
    }

    public static final class Type {
        private static final Map<String, Type> byName = new ConcurrentHashMap<String, Type>();
        private static Collection<Type> allTypes = Collections.unmodifiableCollection(byName.values());
        public static final Type HOT = Type.getType("HOT", new Type[0]);
        public static final Type COLD = Type.getType("COLD", new Type[0]);
        public static final Type SPARSE = Type.getType("SPARSE", new Type[0]);
        public static final Type DENSE = Type.getType("DENSE", new Type[0]);
        public static final Type WET = Type.getType("WET", new Type[0]);
        public static final Type DRY = Type.getType("DRY", new Type[0]);
        public static final Type SAVANNA = Type.getType("SAVANNA", new Type[0]);
        public static final Type CONIFEROUS = Type.getType("CONIFEROUS", new Type[0]);
        public static final Type JUNGLE = Type.getType("JUNGLE", new Type[0]);
        public static final Type SPOOKY = Type.getType("SPOOKY", new Type[0]);
        public static final Type DEAD = Type.getType("DEAD", new Type[0]);
        public static final Type LUSH = Type.getType("LUSH", new Type[0]);
        public static final Type MUSHROOM = Type.getType("MUSHROOM", new Type[0]);
        public static final Type MAGICAL = Type.getType("MAGICAL", new Type[0]);
        public static final Type RARE = Type.getType("RARE", new Type[0]);
        public static final Type PLATEAU = Type.getType("PLATEAU", new Type[0]);
        public static final Type MODIFIED = Type.getType("MODIFIED", new Type[0]);
        public static final Type OCEAN = Type.getType("OCEAN", new Type[0]);
        public static final Type RIVER = Type.getType("RIVER", new Type[0]);
        public static final Type WATER = Type.getType("WATER", OCEAN, RIVER);
        public static final Type MESA = Type.getType("MESA", new Type[0]);
        public static final Type FOREST = Type.getType("FOREST", new Type[0]);
        public static final Type PLAINS = Type.getType("PLAINS", new Type[0]);
        public static final Type HILLS = Type.getType("HILLS", new Type[0]);
        public static final Type SWAMP = Type.getType("SWAMP", new Type[0]);
        public static final Type SANDY = Type.getType("SANDY", new Type[0]);
        public static final Type SNOWY = Type.getType("SNOWY", new Type[0]);
        public static final Type WASTELAND = Type.getType("WASTELAND", new Type[0]);
        public static final Type BEACH = Type.getType("BEACH", new Type[0]);
        public static final Type VOID = Type.getType("VOID", new Type[0]);
        public static final Type UNDERGROUND = Type.getType("UNDERGROUND", new Type[0]);
        public static final Type PEAK = Type.getType("PEAK", new Type[0]);
        public static final Type SLOPE = Type.getType("SLOPE", new Type[0]);
        public static final Type MOUNTAIN = Type.getType("MOUNTAIN", PEAK, SLOPE);
        public static final Type OVERWORLD = Type.getType("OVERWORLD", new Type[0]);
        public static final Type NETHER = Type.getType("NETHER", new Type[0]);
        public static final Type END = Type.getType("END", new Type[0]);
        private final String name;
        private final List<Type> subTypes;
        private final Set<ResourceKey<Biome>> biomes = ConcurrentHashMap.newKeySet();
        private final Set<ResourceKey<Biome>> biomesUn = Collections.unmodifiableSet(this.biomes);

        private Type(String name, Type ... subTypes) {
            this.name = name;
            this.subTypes = ImmutableList.copyOf((Object[])subTypes);
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static synchronized Type getType(String name, Type ... subTypes) {
            return byName.computeIfAbsent(name.toUpperCase(Locale.ENGLISH), n -> new Type((String)n, subTypes));
        }

        public static boolean hasType(String name) {
            return byName.containsKey(name.toUpperCase(Locale.ENGLISH));
        }

        public static Collection<Type> getAll() {
            return allTypes;
        }

        @Nullable
        public static Type fromVanilla(Biome.BiomeCategory category) {
            if (category == Biome.BiomeCategory.NONE) {
                return null;
            }
            if (category == Biome.BiomeCategory.THEEND) {
                return VOID;
            }
            return Type.getType(category.name(), new Type[0]);
        }
    }

    private static class BiomeInfo {
        private final Set<Type> types = new HashSet<Type>();
        private final Set<Type> typesUn = Collections.unmodifiableSet(this.types);

        private BiomeInfo() {
        }
    }
}

